/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class ForceResolutionAP
extends AP6
implements MouseListener,
MouseMotionListener {
    final double PI2 = Math.PI * 2;
    static final String[][] text = new String[][]{{"de", "Zerlegung einer Kraft in zwei Komponenten", "Betrag der gegebenen", "Kraft:", "Winkelgr\u00f6\u00dfen:", "1. Winkel:", "2. Winkel:", "Betr\u00e4ge der Kraftkomponenten:", "1. Komponente", "2. Komponente", "Komponenten ermitteln", "Konstruktion l\u00f6schen", ""}, {"en", "Resolution of a Force into Components", "Magnitude of the given", "force:", "Sizes of the angles:", "1st angle:", "2nd angle:", "Magnitudes of the components:", "1st component", "2nd component", "Find out components", "Clear construction", ""}};
    private int[] gaps = new int[]{15, 5, 15, 10, 10, 15, 10, 10, 15, 15, 15, 5, 15};
    final int width = 620;
    final int height = 400;
    final int width0 = 400;
    FontMetrics fmH;
    CanvasAP cv;
    Panel6 pan;
    JTextField tfForce;
    JTextField tfAngle1;
    JTextField tfAngle2;
    JLabel lbComp1;
    JLabel lbComp2;
    JButton buComp;
    JButton buClear;
    Color bgCanvas;
    Color bgPanel;
    Color colorForce;
    Color colorComp1;
    Color colorComp2;
    Color colorAngle1;
    Color colorAngle2;
    Color colorButton1;
    Color colorButton2;
    String coauthor;
    String text01;
    String text02;
    String text03;
    String text04;
    String text05;
    String text06;
    String text07;
    String text08;
    String text09;
    String text10;
    double pix;
    double force0;
    double f;
    double alpha;
    double beta;
    double f1;
    double f2;
    int x0;
    int y0;
    double phi0;
    double phi1;
    double phi2;
    int nr;
    double t;
    boolean on;
    boolean ready1;
    boolean ready2;

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(620, 400);
    }

    @Override
    protected void initAttributes() {
        this.pix = 50.0;
        this.force0 = 1.0;
        this.f = 5.0;
        this.x0 = 50;
        this.y0 = 200;
        this.phi0 = 0.0;
        this.alpha = 0.3490658503988659;
        this.beta = 0.6981317007977318;
        this.calculation();
    }

    @Override
    protected void initColors() {
        this.bgCanvas = this.getColor(Color.yellow, "bgCanvas");
        this.bgPanel = this.getColor(Color.green, "bgPanel");
        this.colorForce = this.getColor(new Color(192, 0, 192), "colorForce");
        this.colorComp1 = this.getColor(Color.blue, "colorComp1");
        this.colorComp2 = this.getColor(Color.red, "colorComp2");
        this.colorAngle1 = this.getColor(new Color(128, 128, 255), "colorAngle1");
        this.colorAngle2 = this.getColor(new Color(255, 128, 128), "colorAngle2");
        this.colorButton1 = this.getColor(Color.orange, "colorButton1");
        this.colorButton2 = this.getColor(Color.cyan, "colorButton2");
    }

    @Override
    protected void initText() {
        String[] t = this.searchLanguage(text, "en");
        this.language = this.getText(this.language, "language");
        this.title = this.getText(t[1], "title");
        this.text01 = this.getText(t[2], "text01");
        this.text02 = this.getText(t[3], "text02");
        this.text03 = this.getText(t[4], "text03");
        this.text04 = this.getText(t[5], "text04");
        this.text05 = this.getText(t[6], "text05");
        this.text06 = this.getText(t[7], "text06");
        this.text07 = this.getText(t[8], "text07");
        this.text08 = this.getText(t[9], "text08");
        this.text09 = this.getText(t[10], "text09");
        this.text10 = this.getText(t[11], "text10");
        this.coauthor = this.getText(t[12], "coauthor");
    }

    @Override
    protected void initCanvas() {
        this.cv = new CanvasAP(this);
        this.cv.setBounds(0, 0, 400, 400);
        this.add(this.cv);
    }

    @Override
    protected void initPanel() {
        this.pan = new Panel6(this, this.bgPanel, 3, this.gaps);
        this.pan.setBounds(400, 0, 220, 400);
        JLabel lb = new JLabel(this.text01);
        this.pan.add(lb, this.bgPanel, this.colorForce);
        this.tfForce = this.pan.newInputField(this.text02, this.newton, this.bgPanel, this.colorForce, 2);
        this.tfForce.setText(this.toString2(this.f, 3, 1.0E-6));
        this.pan.add(this.text03);
        this.tfAngle1 = this.pan.newInputField(this.text04, "\u00b0", this.bgPanel, this.colorComp1, 2);
        this.tfAngle1.setText(this.toString(this.alpha / (Math.PI / 180), 1));
        this.tfAngle2 = this.pan.newInputField(this.text05, "\u00b0", this.bgPanel, this.colorComp2, 2);
        this.tfAngle2.setText(this.toString(this.beta / (Math.PI / 180), 1));
        this.pan.add(this.text06);
        this.lbComp1 = this.pan.newOutputField(this.text07 + ":", this.newton, this.bgPanel, this.colorComp1, 2);
        this.lbComp1.setText("?");
        this.lbComp2 = this.pan.newOutputField(this.text08 + ":", this.newton, this.bgPanel, this.colorComp2, 2);
        this.lbComp2.setText("?");
        this.buComp = this.pan.newButton(this.text09, this.colorButton1, Color.black);
        this.buClear = this.pan.newButton(this.text10, this.colorButton2, Color.black);
        this.pan.add(2003);
        this.pan.add(this.coauthor);
        this.add(this.pan);
        this.cv.addMouseListener(this);
        this.cv.addMouseMotionListener(this);
    }

    @Override
    public void run() {
        long t0 = System.currentTimeMillis();
        while (this.thr == Thread.currentThread()) {
            if (this.on) {
                this.cv.repaint();
            }
            try {
                Thread.sleep(this.on ? 50L : 100L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            long t1 = System.currentTimeMillis();
            if (this.on) {
                this.t += (double)(t1 - t0) / 1000.0;
            }
            t0 = t1;
        }
    }

    private double diffAngle(double w1, double w2) {
        double w = w1 - w2;
        int n = (int)(w / (Math.PI * 2));
        return w - (double)n * (Math.PI * 2);
    }

    private int compare(double w1, double w2) {
        double w = w1 - w2;
        if (w == 0.0) {
            return 0;
        }
        while (w > Math.PI) {
            w -= Math.PI * 2;
        }
        while (w < -Math.PI) {
            w += Math.PI * 2;
        }
        return w > 0.0 ? 1 : -1;
    }

    private void calculation() {
        this.phi1 = this.phi0 - this.alpha;
        this.phi2 = this.phi0 + this.beta;
        double sinAB = Math.sin(this.alpha + this.beta);
        this.f1 = this.f * Math.sin(this.beta) / sinAB;
        this.f2 = this.f * Math.sin(this.alpha) / sinAB;
    }

    private void changeValues() {
        this.tfForce.setText(this.toString2(this.f, 3, 1.0E-6));
        this.tfAngle1.setText(this.toString(this.alpha / (Math.PI / 180), 1));
        this.tfAngle2.setText(this.toString(this.beta / (Math.PI / 180), 1));
        this.lbComp1.setText(this.ready1 ? this.toString2(this.f1, 3, 1.0E-6) : "?");
        this.lbComp2.setText(this.ready2 ? this.toString2(this.f2, 3, 1.0E-6) : "?");
    }

    private void setPix() {
        double max = this.f;
        if (this.f1 > max) {
            max = this.f1;
        }
        if (this.f2 > max) {
            max = this.f2;
        }
        this.force0 = this.floorP10(max);
        this.pix = max / this.force0 > 5.0 ? 20.0 / this.force0 : (max / this.force0 > 2.0 ? 50.0 / this.force0 : 100.0 / this.force0);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object o = ae.getSource();
        this.f = this.inputTF2(this.tfForce, 0.001, 1000.0, 3, 1.0E-6);
        this.alpha = Math.PI / 180 * this.inputTF(this.tfAngle1, 0.1, 179.0 - this.beta / (Math.PI / 180), 1);
        this.beta = Math.PI / 180 * this.inputTF(this.tfAngle2, 0.1, 179.0 - this.alpha / (Math.PI / 180), 1);
        if (o instanceof JButton) {
            this.t = 0.0;
            this.on = o == this.buComp;
            this.ready2 = false;
            this.ready1 = false;
        }
        this.calculation();
        this.lbComp1.setText(this.ready1 ? this.toString2(this.f1, 3, 1.0E-6) : "?");
        this.lbComp2.setText(this.ready2 ? this.toString2(this.f2, 3, 1.0E-6) : "?");
        this.setPix();
        this.cv.repaint();
    }

    @Override
    public void mousePressed(MouseEvent me) {
        int y;
        int dy;
        double tol1 = 0.05;
        double tol2 = 10.0;
        int x = me.getX();
        int dx = x - this.x0;
        double r = Math.sqrt(dx * dx + (dy = (y = me.getY()) - this.y0) * dy);
        if (r < tol2) {
            this.nr = 1;
            return;
        }
        double phi = Math.atan2(-dy, dx);
        double dphi = Math.abs(this.diffAngle(phi, this.phi0));
        if (dphi < tol1 && r < this.f * this.pix + tol2) {
            this.nr = 2;
            return;
        }
        dphi = Math.abs(this.diffAngle(phi, this.phi1));
        if (dphi < tol1) {
            this.nr = 3;
            return;
        }
        dphi = Math.abs(this.diffAngle(phi, this.phi2));
        if (dphi < tol1) {
            this.nr = 4;
            return;
        }
        this.nr = 0;
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        int xM = me.getX();
        int yM = me.getY();
        if (xM < 10) {
            xM = 10;
        }
        if (xM > 390) {
            xM = 390;
        }
        if (yM < 10) {
            yM = 10;
        }
        if (yM > 390) {
            yM = 390;
        }
        double dx = xM - this.x0;
        double dy = yM - this.y0;
        switch (this.nr) {
            case 0: {
                return;
            }
            case 1: {
                this.x0 = xM;
                this.y0 = yM;
                break;
            }
            case 2: {
                this.f = Math.sqrt(dx * dx + dy * dy) / this.pix;
                if (this.f > 1000.0) {
                    this.f = 1000.0;
                }
                if (this.f < 0.001) {
                    this.f = 0.001;
                }
                this.phi0 = Math.atan2(-dy, dx);
                this.calculation();
                this.changeValues();
                break;
            }
            case 3: {
                int dir;
                double phi = Math.atan2(-dy, dx);
                this.alpha = this.diffAngle(this.phi0, phi);
                if (this.alpha < 0.0) {
                    this.alpha += Math.PI * 2;
                }
                if ((dir = this.compare(phi, this.phi1)) > 0 && this.compare(phi, this.phi0) >= 0) {
                    this.alpha = Math.PI / 180;
                    this.phi0 = phi + this.alpha;
                }
                if (dir < 0 && this.compare(phi, this.phi0 + this.beta - 3.12413936106985) < 0) {
                    if (this.alpha > 3.12413936106985) {
                        this.alpha = 3.12413936106985;
                    }
                    this.phi0 = phi + this.alpha;
                    this.beta = 3.12413936106985 - this.alpha;
                }
                this.calculation();
                this.changeValues();
                break;
            }
            case 4: {
                int dir;
                double phi = Math.atan2(-dy, dx);
                this.beta = this.diffAngle(phi, this.phi0);
                if (this.beta < 0.0) {
                    this.beta += Math.PI * 2;
                }
                if ((dir = this.compare(phi, this.phi2)) < 0 && this.compare(phi, this.phi0) <= 0) {
                    this.beta = Math.PI / 180;
                    this.phi0 = phi - this.beta;
                }
                if (dir > 0 && this.compare(phi, this.phi0 - this.alpha + 3.12413936106985) > 0) {
                    if (this.beta > 3.12413936106985) {
                        this.beta = 3.12413936106985;
                    }
                    this.phi0 = phi - this.beta;
                    this.alpha = 3.12413936106985 - this.beta;
                }
                this.calculation();
                this.changeValues();
            }
        }
        this.cv.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    class CanvasAP
    extends Canvas6 {
        CanvasAP(AP6 ap) {
            super(ap, ForceResolutionAP.this.bgCanvas);
            ForceResolutionAP.this.fmH = this.getFontMetrics(this.fH);
        }

        private void write(Graphics2D g, String s, double phi, double r) {
            int x = (int)Math.round((double)ForceResolutionAP.this.x0 + r * Math.cos(phi));
            int y = (int)Math.round((double)ForceResolutionAP.this.y0 - r * Math.sin(phi));
            this.alignText(g, s, this.fH, 1, x, y);
        }

        private void line(Graphics2D g, double x0, double y0, double phi, double len, int type) {
            int infty = 1240;
            if (len > (double)infty) {
                len = infty;
            }
            double sin = Math.sin(phi);
            double cos = Math.cos(phi);
            double x = type == 2 ? x0 - (double)infty * cos : x0;
            double y = type == 2 ? y0 + (double)infty * sin : y0;
            double r = type == 0 ? len : (double)infty;
            CanvasAP.line(g, x, y, x0 + r * cos, y0 - r * sin);
        }

        private void thickArrow(Graphics2D g, double phi, double r) {
            r = Math.min(r, 1240.0);
            double x = (double)ForceResolutionAP.this.x0 + r * Math.cos(phi);
            double y = (double)ForceResolutionAP.this.y0 - r * Math.sin(phi);
            CanvasAP.arrow(g, 3.0, ForceResolutionAP.this.x0, ForceResolutionAP.this.y0, x, y);
        }

        private void angle(Graphics2D g, double w0, double dw, Color c) {
            int n = (int)Math.floor(w0 / (Math.PI * 2));
            w0 -= (double)n * (Math.PI * 2);
            n = (int)Math.floor(dw / (Math.PI * 2));
            CanvasAP.angle(g, ForceResolutionAP.this.x0, ForceResolutionAP.this.y0, 20.0, w0, dw -= (double)n * (Math.PI * 2), c);
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            g.setClip(1, 1, 398, 398);
            Graphics2D g2 = (Graphics2D)g;
            CanvasAP.setAntiAliasing(g2, true);
            g.setFont(this.fH);
            g.setColor(Color.black);
            CanvasAP.arrow(g2, 3.0, 50.0, 350.0, 50.0 + ForceResolutionAP.this.force0 * ForceResolutionAP.this.pix, 350.0);
            String f0 = "" + (int)Math.round(ForceResolutionAP.this.force0) + " " + ForceResolutionAP.this.newton;
            if (ForceResolutionAP.this.force0 < 1.0) {
                f0 = "" + ForceResolutionAP.this.toString2(ForceResolutionAP.this.force0, 1, 1.0E-6) + " " + ForceResolutionAP.this.newton;
            }
            this.alignText(g2, f0, this.fH, 1, 50 + (int)(ForceResolutionAP.this.force0 * ForceResolutionAP.this.pix / 2.0), 370);
            double xF = (double)ForceResolutionAP.this.x0 + ForceResolutionAP.this.f * ForceResolutionAP.this.pix * Math.cos(ForceResolutionAP.this.phi0);
            double yF = (double)ForceResolutionAP.this.y0 - ForceResolutionAP.this.f * ForceResolutionAP.this.pix * Math.sin(ForceResolutionAP.this.phi0);
            CanvasAP.circle(g2, ForceResolutionAP.this.x0, ForceResolutionAP.this.y0, 5.0, Color.white, true);
            this.angle(g2, ForceResolutionAP.this.phi1, ForceResolutionAP.this.alpha, ForceResolutionAP.this.colorAngle1);
            this.angle(g2, ForceResolutionAP.this.phi0, ForceResolutionAP.this.beta, ForceResolutionAP.this.colorAngle2);
            g.setColor(ForceResolutionAP.this.colorForce);
            this.thickArrow(g2, ForceResolutionAP.this.phi0, ForceResolutionAP.this.f * ForceResolutionAP.this.pix);
            g.setColor(ForceResolutionAP.this.colorComp1);
            this.line(g2, ForceResolutionAP.this.x0, ForceResolutionAP.this.y0, ForceResolutionAP.this.phi1, 1.0, 1);
            g.setColor(ForceResolutionAP.this.colorComp2);
            this.line(g2, ForceResolutionAP.this.x0, ForceResolutionAP.this.y0, ForceResolutionAP.this.phi2, 1.0, 1);
            double q1 = Math.min(ForceResolutionAP.this.t / 5.0, 1.0);
            double q2 = Math.min((ForceResolutionAP.this.t - 5.0) / 5.0, 1.0);
            double q3 = Math.min((ForceResolutionAP.this.t - 10.0) / 5.0, 1.0);
            double q4 = Math.min((ForceResolutionAP.this.t - 15.0) / 5.0, 1.0);
            double dx = xF - (double)ForceResolutionAP.this.x0;
            double dy = yF - (double)ForceResolutionAP.this.y0;
            g.setColor(Color.black);
            if (ForceResolutionAP.this.t > 0.0) {
                this.line(g2, (double)ForceResolutionAP.this.x0 + q1 * dx, (double)ForceResolutionAP.this.y0 + q1 * dy, ForceResolutionAP.this.phi1 + Math.PI, ForceResolutionAP.this.f1 * ForceResolutionAP.this.pix, ForceResolutionAP.this.t < 10.0 ? 2 : 0);
            }
            if (ForceResolutionAP.this.t > 5.0) {
                this.line(g2, (double)ForceResolutionAP.this.x0 + q2 * dx, (double)ForceResolutionAP.this.y0 + q2 * dy, ForceResolutionAP.this.phi2 + Math.PI, ForceResolutionAP.this.f2 * ForceResolutionAP.this.pix, ForceResolutionAP.this.t < 10.0 ? 2 : 0);
            }
            if (ForceResolutionAP.this.t > 10.0) {
                g.setColor(ForceResolutionAP.this.colorComp1);
                this.write(g2, ForceResolutionAP.this.text07, ForceResolutionAP.this.phi1 - 0.2, ForceResolutionAP.this.f1 * ForceResolutionAP.this.pix * 0.5);
                this.thickArrow(g2, ForceResolutionAP.this.phi1, ForceResolutionAP.this.f1 * ForceResolutionAP.this.pix * q3);
            }
            if (ForceResolutionAP.this.t > 15.0) {
                g.setColor(ForceResolutionAP.this.colorComp2);
                this.write(g2, ForceResolutionAP.this.text08, ForceResolutionAP.this.phi2 + 0.2, ForceResolutionAP.this.f2 * ForceResolutionAP.this.pix * 0.5);
                this.thickArrow(g2, ForceResolutionAP.this.phi2, ForceResolutionAP.this.f2 * ForceResolutionAP.this.pix * q4);
                if (!ForceResolutionAP.this.ready1) {
                    ForceResolutionAP.this.ready1 = true;
                    ForceResolutionAP.this.changeValues();
                }
            }
            if (ForceResolutionAP.this.t > 20.0 && !ForceResolutionAP.this.ready2) {
                ForceResolutionAP.this.ready2 = true;
                ForceResolutionAP.this.changeValues();
            }
        }
    }
}

